<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">

    <title>Food Trucks</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Shadows+Into+Light&display=swap" rel="stylesheet">

    <link href="https://fonts.googleapis.com/css?family=Faster+One" rel="stylesheet">
    <link rel="stylesheet" href="style.css">
  </head>

  <body>
 

      </header>

      <section>

      </section>
      
     
       
      
      
    <script>
    const header = document.querySelector('header');
    const section = document.querySelector('section');

    //connect to the JSON file and send the request

    let requestURL = 'https://data.opendatasoft.com/api/explore/v2.1/catalog/datasets/brisbane-food-trucks@prod-brisbane-queensland/records?limit=20';    //add url to connect to api
    let request = new XMLHttpRequest();
    request.open('GET', requestURL);
    request.responseType = 'json';
    request.send();
   
    request.onload = function() {
    const  foodTrucks= request.response;  //add a constant variable to store response
    populateHeader(foodTrucks);  //add constant variable name here
    showTrucks(foodTrucks);   //add constant variable name here
}
//append the header with the truck name
function populateHeader(jsonObj) {
  const myH1 = document.createElement('h1');
  myH1.textContent = jsonObj['name'];  //add here the variable name for header title
  header.appendChild(myH1);//this data will be placed in html header part  
  const myPara = document.createElement('p');
  header.appendChild(myPara);
}

//loop through the food truck details and create cards

function showTrucks(jsonObj) {
  const trucks = jsonObj['results'];  //add here the main api 
      
  for (let i = 0; i < trucks.length; i++) {
    const myArticle = document.createElement('article');
    const myH2 = document.createElement('h2');
    const myPara1 = document.createElement('p');
    const myPara2 = document.createElement('p');
    const myPara3 = document.createElement('p');
    const image = document.createElement('img');
    
    const myList = document.createElement('ul');

    myH2.textContent = trucks[i].name;
    myPara1.textContent = 'Category: ' + trucks[i].category; //add data name to be placed here
    myPara2.textContent = 'Bio: ' + trucks[i].bio;
    myPara3.textContent = 'Instagram: ' + trucks[i].instagram_handle;
    image.imageObj = 'Avatar"'+ trucks[i].avatar;
   
    //display character image with an alt tag showing the name
       
      image.src = trucks[i].avatar;
      image.setAttribute("width", "200");
      image.setAttribute("alt", + trucks[i].name);
      
    myArticle.appendChild(myH2);
    myArticle.appendChild(myPara1);
    myArticle.appendChild(myPara2);
    myArticle.appendChild(myPara3);
    myArticle.appendChild(image);
    section.appendChild(myArticle); //this data will be placed in html section part
  }
}
    </script>
  </body>
</html>