function showDiv() {
document.getElementById('info').style.display = "block";
document.getElementById('list').style.display = "none";
}
function hideDiv() {
document.getElementById('info').style.display = "none";
document.getElementById('list').style.display = "block";
}


const section = document.querySelector('section');
const displayData = (data) => {
if (!data) return;
const columns = [
{ name: "truck_id", label: "Truck ID" },
{ name: "category", label: "Type of Food" },
{ name: "name", label: "Truck Name" },
{ name: "bio", label: "Description" },
{ name: "avatar", label: "Image" },
{ name: "website", label: "website" }
];
const heading = document.createElement("h1");
heading.textContent = "Food Trucks of Brisbane";
section.appendChild(heading);

const welcome = document.createElement("p");
welcome.textContent = "Welcome to Food Trucks of Brisbane! On our site you can find every food truck within Brisbane. See table below for more information about each truck."
section.appendChild(welcome);

const paragraph = document.createElement("p");
paragraph.textContent = "To view the locations and corressponding times and dates of each truck, please press the Truck Bookings button below. Please note that you must enter the truck ID of your desired truck, which you can find in the table below.";
section.appendChild(paragraph);

const buttonDiv = document.createElement(("div"));
buttonDiv.setAttribute("class","buttonDiv");

const bookingsButton = document.createElement(("a"));

bookingsButton.setAttribute("class", "button2");
bookingsButton.setAttribute("href","truckSites.html");
bookingsButton.textContent = "Truck Bookings";
buttonDiv.appendChild(bookingsButton);
section.appendChild(buttonDiv);

let requestURL = 'https://data.opendatasoft.com/api/explore/v2.1/catalog/datasets/brisbane-food-trucks@prod-brisbane-queensland/records?limit=20';
let request = new XMLHttpRequest();
request.open('GET', requestURL);
request.responseType = 'json';
request.send();
request.onload = function() {
const data = request.response;
displayData(data);
};


const table = document.createElement("table");
table.setAttribute("id","list");

const thead = document.createElement("thead");
const thead_row = document.createElement("tr");

for (let i = 0, ii = columns.length-3; i < ii; i++) {
const th = document.createElement("th");
th.appendChild(document.createTextNode(columns[i].label));
th.setAttribute("class","rowLabel");
thead_row.appendChild(th);
}
thead.appendChild(thead_row);
table.appendChild(thead);
table.setAttribute("class","table");
const tbody = document.createElement("tbody");

for (let i = 0, ii = data.length; i < ii; i++) {
const row = document.createElement("tr");

for (j = 0, jj = columns.length-3; j < jj; j++) {
const td = document.createElement(("td"));
td.appendChild(document.createTextNode(data[i][columns[j].name]));
td.setAttribute("id","tableCell")
row.appendChild(td);

if (j == 2) {
const infoButton = document.createElement(("button"));
infoButton.setAttribute("onclick", "showDiv()");
infoButton.textContent="More info about "+data[i][columns[j].name];
row.appendChild(infoButton);
const info = document.createElement(("div"));
info.setAttribute("id","info");
info.setAttribute("style","display:none");
const selectedTruckName = document.createElement("h1");
selectedTruckName.setAttribute("class","truckName");
selectedTruckName.textContent = data[i][columns[2].name]+" (ID: "+data[i][columns[0].name]+")";
const description = document.createElement("p");
description.textContent = data[i][columns[3].name];
const serving = document.createElement("p");
serving.textContent = "Serves " + data[i][columns[1].name] + " Food";
const truckImage = document.createElement(("img"));
truckImage.setAttribute("src",data[i][columns[4].name].src)
truckImage.setAttribute("alt","Food Truck Image");
truckImage.setAttribute("height", "200px");
const website = document.createElement("p");
const websiteLink = data[i][columns[5].name];

if (websiteLink.length > 0) {
website.textContent = "Website: " + data[i][columns[5].name];
} else {
website.textContent = "This truck does not have an associated website.";
}
const backButton = document.createElement(("button"));
backButton.textContent = "Back to List";
backButton.setAttribute("onclick", "hideDiv()");
backButton.setAttribute("class", "backButton")
info.appendChild(selectedTruckName);
info.appendChild(truckImage);
info.appendChild(website);
info.appendChild(serving);
info.appendChild(description);
info.appendChild(backButton);
section.appendChild(info);
};
}
tbody.appendChild(row);
}
table.appendChild(tbody);
section.appendChild(table);
};
