const ajax = (request) => {
    return new Promise((resolve, reject) => {
      const xhr = new XMLHttpRequest();
      xhr.open(request.method, request.url, true);
      xhr.addEventListener("load", (e) => {
        resolve(e.target);
      });
      xhr.send();
    });
  };
  
  const hash = "7fe2d046dc69a7bd370ac31c764318d71773497d";
  const apiKey = "d5065e322560584aee3e3356c7ee741a";
  const url = `https://gateway.marvel.com:443/v1/public/characters?ts=1&apikey=${apiKey}&hash=${hash}&limit=20&nameStartsWith=iron%20man`;
  
  const myRequest = {
    method: "GET",
    url: url
  };
  
  
  ajax(myRequest)
    .then(response => {
      switch (response.status) {
        case 200:
          return JSON.parse(response.responseText).data.results
        case 400:
          console.log('error', response.statusText)
          break
        default:
          console.log('estado desconocido', response.status)
      }
    })
    .then(data => {
      draw(data)
    })
  
  
  const request = async () => {
    const response = await ajax(myRequest);
    switch (response.status) {
      case 200:
        draw(JSON.parse(response.responseText).data.results);
      case 400:
        console.log("error", response.statusText);
        break;
      default:
        console.log("estado desconocido", response.status);
    }
  };
  
  const draw = (data) => {
    const fragment = document.createDocumentFragment();
    data.forEach((comic) => {
      const container = document.createElement("div");
      const title = document.createElement("h2");
      const image = document.createElement("img");
  
      title.textContent = comic.name;
      image.src = `${comic.thumbnail.path}/portrait_incredible.${comic.thumbnail.extension}`;
      fragment.appendChild(title);
      fragment.appendChild(image);
    });
  
    myContent.appendChild(fragment);
  };
  
  request();
  