$('#input-name').focus()

$('#mrvl-form').submit((e) => {
  e.preventDefault()
})

class MarvelAPI {
  constructor () {
    this.baseURL = 'https://gateway.marvel.com:443/v1/public/characters?'
    this.key = 'd5065e322560584aee3e3356c7ee741a'
    this.elements = {
      'form': $('#mrvl-form'),
      'input': $('#input-name'),
      'resultsNumber': $('#results-number'),
      'results': $('#results'),
      'img': $('#result-image'),
      'description': $('#description'),
      'comics': $('#comics-list'),
      'series': $('#series-list')
    }

    this.params = {
      'apikey': 'd5065e322560584aee3e3356c7ee741a',
      'orderBy': 'name',
      'limit': 30,
      'offset': 0
    }

    this.registerEvents()
  } // constructor

  callApi (options, callback) {
    //  let resultNumber = this.elements.resultsNumber.val()
    const fullURL = `${this.baseURL}`

    this.params = $.extend(this.params, options)

    $.getJSON(fullURL, this.params)
      .done((data) => {
        callback(data)
      })
      .fail((response) => {
        callback(null)
      })
  }

  getCharacterByName (name, callback) {
    delete this.params.nameStartsWith

    this.callApi(
      {
        'name': name,
        'limit': this.elements.resultsNumber.val()
      },
      (data) => {
        this.showData(data.data)
      }
    )
  }

  getCharacterByNameStartsWith (name, callback) {
    delete this.params.name

    this.callApi(
      {
        'nameStartsWith': name,
        'limit': this.elements.resultsNumber.val()
      },
      (data) => {
        this.showData(data.data)
      }
    )
  }

  registerEvents () {
    this.elements.form.on('submit', (e) => {
      e.preventDefault()

      this.getCharacterByName(
        this.elements.input.val().trim(),
        (data) => {
        }
      )

      this.getCharacterByNameStartsWith(
        this.elements.input.val().trim(),
        (data) => {
        }
      )
    })
  }

  showData (data) {
    this.elements.results.html('')

    if (data.results.length === 0) {
      this.elements.results.append(`<p class="not-found"> - Sorry no results found - </p> <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAz1BMVEVHcEz/xkD+y0b6vhn7vA/9ykb9xzr6uQj8xTX/xjT7vRRk0fj8xzz/wi7+xzn7vxtdzvb9ykdczvZZzvR50uxt1f39ykb9ykf0tSL9ykf5twAwLDt11v+RdST/6LtXzPP7vhb5yEfxwEX8xzrDnThXSj3jtkG66v/+1W8/Nzywji7RqUX8wyz9yUXbrz36z1xvXT6dfib+3Y3/5ayF2/+NckHsu0OcgEGB0+jppSqDbECY09HRpjiujEK6xo6y6f/czXWa4v+y0a2Nv6ydnWuwDRnQAAAAGXRSTlMAGKWr6+m9/WkH1/5MKzaRnpBRzj8jhc+Gg2PHGAAAA/dJREFUWMPVmNl2qjAUhh0JWofOPUQcgoAjOLTVqrV2eP93OgmBmAQQ41nnovvGtUzy8e8/ySYkl/tdka/pN4WCphUKN3otfylEL5QNIcoFXRlWqWlGYmi1igpGD7TMhkmosl5RwcyWz53OMlnVmajGk2EMMaWznBlp8dTIlvOYjSHxmCEqr1HM82kMcf3kBNbLxrLTSTVHdOpEeo3y7Dw5oeepHDQ8V04QUz0tr5kSxzB6tUSfaV7D8zmGB+oJ864ZqhycXCm+Ch6D+VLj4OS0mNHG8AKO14eS4ZUnktjQ8AxVSUBMTieCVPUELsGiIKiMBV3CwRMH8oKgWWz9eLYr/+PaKJ4bLwkLWi4lf9C4vZAHLdrjGKkPOZdquHRI7e6i3W6vxP9W+K+FLNMAsMlAsfps2XhM7PFYJA7bknMrsc0hYdD7IomDTQpI7XckzhusM6t5ij8OMAs/aZJ82jb2EWcSy60QPg+5vk0p7bGfsjQ9n6pajG3fDZL0IKyGoOg96LdpjPHEpy9x5NrjsKMfug1ki95t2353UfYyRG7QlWrsRSbVOOEKe431xSA97vUFgUF0cd/8O6jKT9r/AVlW2rB4CwaVEjeItXdGrVbLWa/kIau1gxtGzp6HeTIomvUJodCwRY7NGkYTYdeGIJoaevuk2/7IabX4/mjCNYyORQCvbAH0be6C31eue2vOC5rzLa/8XgvNJtOPPk3z5TvW3eFBTvIjpgxEFuTszXw5mCS5Nd99y4O2fMuan7RwQeIt4u2woMHXG5kzJ9EJyT3H4r0OtwjetDgxDDqYH4TEknOksuqyZ8wtwSLYiMrILgBhSYgsA/917jjz10l8NU5oiy8WyKiM5ApEkGkOBgPqt1IAeCxs+i4AHbAkc6bICTKLSu19wDG/BqFLijv2WPyvKeiF5La7QBB7HV2ZEelgKubW4zO7jUBBfCgLYq/sawG0UxbEDhHXXR70pnQ4IoLYseYuA4RWK5SeGHequetepYEsextUS1wVt/LhAZ+xBIdIajyJA1lCbcI1yIobxB9Gb7s4QsxV94e9I/ejlhSjfYwjHI/vCOmKBP5l54x1KyHWEkc8sN93j/GxCRWRCj2ar/cT10LIWk3s9XzEVXHKAdKn1i3H2UQGOdtokMdeMNuwoHmUA2MfNQ/XAeZnstlY5yxoAGWjOdb9Q+7PZrM6dx2mccLKBKbZnx9hWqB28qO21OufzirEwFLGF3tFg72pl4mBWvYdgo7PhImy+lMQYYB+1pVGEQ8AvWnf44yZ9hgFguK5tyP5Ih0FejQgH6CocvdTaZZgYpSaFdUrpHqzCkQIqDbrF95q1fVitVrCUa0W9Ubud8Vf98mGAUzPxdkAAAAASUVORK5CYII=">`)
      return
    }

    
    data.results.forEach((item) => {
      let description = '- no description -'
      // comics list
      let comics = `<ul class="flat-list" id="comics-list"> <h2 style="color:white"> Comics</h2>`

      item.comics.items.forEach((comic) => {
        comics += `<li class="list-item"><p>${comic.name}</p></li>`
      })

      comics += `</ul>`

      // series list
      let series = `<ul class="flat-list" id="series-list"> <h2 style="color:white"> Series</h2>`

      item.series.items.forEach((serie) => {
        series += `<li class="list-item"><p>${series.name}</p></li>`
      })

      series += `</ul>`

      if (item.description.length > 0) {
        description = item.description
      }

      this.elements.results.append(`
            <ul class="character-list switch">
                <li class="list-item" data-id="1009610">
                    <div class="name">${item.name}</div>
                    <div class="thumbnail">
                        <img src="${item.thumbnail.path}.${item.thumbnail.extension}"
                             width="250"
                             height="250">
                    </div>

                    <div class="description text-center" id="description">
                        <p> ${description} </p>
                    </div>

                    <div class="hidden comics text-center">
                           ${comics}
                    </div>

                    <div class="hidden series text-center">
                           ${series}
                    </div>


                    </div>
                </li>
            </ul>
      `)
    })

    $('#results .list-item').click((event) => {
      $(event.currentTarget).find('.comics').toggleClass('hidden')
      $(event.currentTarget).find('.series').toggleClass('hidden')
    })
  }
} // class

const mrvl = new MarvelAPI();
